DROP PROCEDURE IF EXISTS `UpdateTracks`;

DELIMITER $$

CREATE PROCEDURE UpdateTracks(IN trackID INT, IN tType INT, IN curListeners INT, IN historyDays INT, IN pWeight DOUBLE)
BEGIN

SET @tArtist = (SELECT artist FROM songs WHERE ID=trackID);

-- Update Count Played
UPDATE `songs` SET `count_played`=`count_played`+1, `date_played`=NOW() WHERE `ID`=trackID;

-- UPDATE ARTISTS
IF tType = 0 OR tType = 9 THEN
    UPDATE `songs` SET `artist_played`=NOW() WHERE `artist`=@tArtist;
END IF;

-- UPDATE REQUESTS
IF tType = 9 THEN
    UPDATE `requests` SET `played`=1 WHERE `songID`=trackID;
END IF;

-- DISABLE BY PLAYCOUNT
UPDATE `songs` SET `enabled`=0, `play_limit`=0 WHERE `enabled`=1 AND `play_limit`>0 AND `count_played`>=`play_limit` AND `limit_action`=1;

-- DELETE BY PLAYCOUNT
DELETE FROM `songs` WHERE `play_limit`>0 AND `count_played`>=`play_limit` AND `limit_action`=2;

-- UPDATE WEIGHT
IF pWeight>0 THEN
    UPDATE `songs` SET `weight`=`weight`-pWeight WHERE `ID`=trackID AND (`weight`-pWeight)>=0;
END IF;

-- UPDATE HISTORY
IF historyDays > 0 THEN
    INSERT INTO `history`(date_played, song_type, id_subcat, id_genre, duration, artist, original_artist, title, album, composer, `year`, track_no, disc_no, publisher, copyright, isrc, listeners)
    SELECT NOW(), song_type, id_subcat, id_genre, duration, artist, original_artist, title, album, composer, `year`, track_no, disc_no, publisher, copyright, isrc, curListeners FROM `songs` WHERE ID=trackID;
END IF;

-- DELETE OLDER ENTRIES FROM HISTORY
DELETE FROM `history` WHERE TIMESTAMPDIFF(DAY, `date_played`, NOW()) >= historyDays;
END $$

DELIMITER ;

ALTER TABLE `songs` CHANGE `count_played` `count_played` INT NOT NULL DEFAULT '0';
ALTER TABLE `songs` CHANGE `weight` `weight` DOUBLE(5, 1) NOT NULL DEFAULT '50';
ALTER TABLE `songs` CHANGE `duration` `duration` DOUBLE(11, 5) NOT NULL;
ALTER TABLE `songs` CHANGE `bpm` `bpm` DOUBLE(11, 1) NOT NULL;
ALTER TABLE `songs` CHANGE `fade_type` `fade_type` TINYINT(1) NOT NULL DEFAULT '0';

ALTER TABLE `songs` ADD `precise_cue` TINYINT(1) NOT NULL DEFAULT '0' AFTER `cue_times`;
ALTER TABLE `songs` ADD `end_type` TINYINT(1) NOT NULL DEFAULT '0' AFTER `fade_type`;
ALTER TABLE `songs` CHANGE `overlay` `overlay` TINYINT(1) NOT NULL DEFAULT '0' AFTER `end_type`;

ALTER TABLE `playlists_list` CHANGE `cstart` `cstart` DOUBLE(11, 5) NOT NULL;
ALTER TABLE `playlists_list` CHANGE `cnext` `cnext` DOUBLE(11, 5) NOT NULL;
ALTER TABLE `playlists_list` CHANGE `cend` `cend` DOUBLE(11, 5) NOT NULL;
ALTER TABLE `playlists_list` CHANGE `fin` `fin` DOUBLE(11, 5) NOT NULL;
ALTER TABLE `playlists_list` CHANGE `fout` `fout` DOUBLE(11, 5) NOT NULL;
ALTER TABLE `playlists_list` CHANGE `swplay` `swplay` DOUBLE(11, 5) NOT NULL;
ALTER TABLE `playlists_list` CHANGE `vtplay` `vtplay` DOUBLE(11, 5) NOT NULL;

ALTER TABLE `history` CHANGE `duration` `duration` DOUBLE(11, 5) NOT NULL;

ALTER TABLE `queuelist` CHANGE `swID` `swID` INT(11) NOT NULL DEFAULT '-1';
ALTER TABLE `queuelist` CHANGE `swPlay` `swPlay` DOUBLE(11, 5) NOT NULL DEFAULT '0';
ALTER TABLE `queuelist` CHANGE `vtID` `vtID` INT(11) NOT NULL DEFAULT '-1';
ALTER TABLE `queuelist` CHANGE `vtPlay` `vtPlay` DOUBLE(11, 5) NOT NULL DEFAULT '0';

UPDATE `songs` SET `precise_cue`=`fade_type`;
ALTER TABLE `rotations_list` ADD COLUMN `data` TEXT NOT NULL AFTER `ord`;